/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Concat;

public final class ConcatEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final BreakingBytesRefBuilder scratch;
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;

    public ConcatEvaluator(BreakingBytesRefBuilder scratch, EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.scratch = scratch;
        this.values = values;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        Block.Ref[] valuesRefs = new Block.Ref[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesRefs);){
            BytesRefBlock[] valuesBlocks = new BytesRefBlock[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesRefs[i] = this.values[i].eval(page);
                Block block = valuesRefs[i].block();
                if (block.areAllValuesNull()) {
                    Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                    return ref;
                }
                valuesBlocks[i] = (BytesRefBlock)block;
            }
            BytesRefVector[] valuesVectors = new BytesRefVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valuesBlocks));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valuesVectors).asBlock());
            return ref;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock[] valuesBlocks) {
        try (BytesRefBlock.Builder result = BytesRefBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef[] valuesValues = new BytesRef[this.values.length];
            BytesRef[] valuesScratch = new BytesRef[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                valuesScratch[i] = new BytesRef();
            }
            block6: for (int p = 0; p < positionCount; ++p) {
                int i;
                for (i = 0; i < valuesBlocks.length; ++i) {
                    if (!valuesBlocks[i].isNull(p) && valuesBlocks[i].getValueCount(p) == 1) continue;
                    result.appendNull();
                    continue block6;
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getBytesRef(o, valuesScratch[i]);
                }
                result.appendBytesRef(Concat.process(this.scratch, valuesValues));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector[] valuesVectors) {
        try (BytesRefVector.Builder result = BytesRefVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef[] valuesValues = new BytesRef[this.values.length];
            BytesRef[] valuesScratch = new BytesRef[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                valuesScratch[i] = new BytesRef();
            }
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getBytesRef(p, valuesScratch[i]);
                }
                result.appendBytesRef(Concat.process(this.scratch, valuesValues));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "ConcatEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.scratch, () -> Releasables.close((Releasable[])this.values)});
    }
}

