/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.esql.EsqlClientException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ConcatEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Concat
extends ScalarFunction
implements EvaluatorMapper {
    static final long MAX_CONCAT_LENGTH = ByteSizeUnit.MB.toBytes(1L);

    public Concat(Source source, Expression first, List<? extends Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = Expression.TypeResolution.TYPE_RESOLVED;
        for (Expression value : this.children()) {
            resolution = TypeResolutions.isString((Expression)value, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return resolution;
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        List<EvalOperator.ExpressionEvaluator.Factory> values = this.children().stream().map(toEvaluator).toList();
        return dvrCtx -> new ConcatEvaluator(new BreakingBytesRefBuilder(dvrCtx.breaker(), "concat"), (EvalOperator.ExpressionEvaluator[])values.stream().map(fac -> fac.get(dvrCtx)).toArray(EvalOperator.ExpressionEvaluator[]::new), dvrCtx);
    }

    static BytesRef process(BreakingBytesRefBuilder scratch, BytesRef[] values) {
        scratch.grow(Concat.checkedTotalLength(values));
        scratch.clear();
        for (int i = 0; i < values.length; ++i) {
            scratch.append(values[i]);
        }
        return scratch.bytesRefView();
    }

    private static int checkedTotalLength(BytesRef[] values) {
        int length = 0;
        for (BytesRef v : values) {
            length += v.length;
        }
        if ((long)length > MAX_CONCAT_LENGTH) {
            throw new EsqlClientException("concatenating more than [" + MAX_CONCAT_LENGTH + "] bytes is not supported", new Object[0]){

                public RestStatus status() {
                    return RestStatus.BAD_REQUEST;
                }
            };
        }
        return length;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Concat(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Concat::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }
}

