/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.nulls;

import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Coalesce
extends ScalarFunction
implements EvaluatorMapper,
OptionalArgument {
    private DataType dataType;

    public Coalesce(Source source, Expression first, List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        for (int position = 0; position < this.children().size(); ++position) {
            if (this.dataType == null || this.dataType == DataTypes.NULL) {
                this.dataType = ((Expression)this.children().get(position)).dataType();
                continue;
            }
            Expression.TypeResolution resolution = TypeResolutions.isType((Expression)((Expression)this.children().get(position)), t -> t == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Nullability nullable() {
        for (Expression c : this.children()) {
            if (c.nullable() != Nullability.FALSE) continue;
            return Nullability.FALSE;
        }
        return Nullability.UNKNOWN;
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Coalesce(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Coalesce::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return dvrCxt -> new CoalesceEvaluator(dvrCxt, LocalExecutionPlanner.toElementType(this.dataType()), this.children().stream().map(toEvaluator).map(x -> x.get(dvrCxt)).toList());
    }

    private record CoalesceEvaluator(DriverContext driverContext, ElementType resultType, List<EvalOperator.ExpressionEvaluator> evaluators) implements EvalOperator.ExpressionEvaluator
    {
        public Block.Ref eval(Page page) {
            int positionCount = page.getPositionCount();
            try (Block.Builder result = this.resultType.newBlockBuilder(positionCount, this.driverContext.blockFactory());){
                block16: for (int p = 0; p < positionCount; ++p) {
                    int[] positions = new int[]{p};
                    Page limited = new Page(1, (Block[])IntStream.range(0, page.getBlockCount()).mapToObj(b -> page.getBlock(b).filter(positions)).toArray(Block[]::new));
                    try (Releasable ignored = () -> ((Page)limited).releaseBlocks();){
                        for (EvalOperator.ExpressionEvaluator eval : this.evaluators) {
                            Block.Ref ref = eval.eval(limited);
                            try {
                                if (ref.block().isNull(0)) continue;
                                result.copyFrom(ref.block(), 0, 1);
                                continue block16;
                            }
                            finally {
                                if (ref == null) continue;
                                ref.close();
                            }
                        }
                        result.appendNull();
                        continue;
                    }
                }
                Block.Ref ref = Block.Ref.floating((Block)result.build());
                return ref;
            }
        }

        @Override
        public String toString() {
            return "CoalesceEvaluator[values=" + this.evaluators + "]";
        }

        public void close() {
            Releasables.closeExpectNoException(() -> Releasables.close(this.evaluators));
        }
    }
}

