/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;
import org.elasticsearch.xpack.ql.tree.Source;

public final class MvSumIntEvaluator
extends AbstractMultivalueFunction.AbstractNullableEvaluator {
    private final Warnings warnings;
    private final DriverContext driverContext;

    public MvSumIntEvaluator(Source source, EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(field);
        this.warnings = new Warnings(source);
        this.driverContext = driverContext;
    }

    @Override
    public String name() {
        return "MvSum";
    }

    @Override
    public Block.Ref evalNullable(Block.Ref ref) {
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block17: {
                IntBlock v = (IntBlock)ref.block();
                int positionCount = v.getPositionCount();
                IntBlock.Builder builder = IntBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        if (valueCount == 0) {
                            builder.appendNull();
                            continue;
                        }
                        try {
                            int first = v.getFirstValueIndex(p);
                            int end = first + valueCount;
                            int value = v.getInt(first);
                            for (int i = first + 1; i < end; ++i) {
                                int next = v.getInt(i);
                                value = MvSum.process(value, next);
                            }
                            int result = value;
                            builder.appendInt(result);
                            continue;
                        }
                        catch (ArithmeticException e) {
                            this.warnings.registerException(e);
                            builder.appendNull();
                        }
                    }
                    ref3 = Block.Ref.floating((Block)builder.build());
                    if (builder == null) break block17;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }
}

