/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.List;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSumDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSumIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSumLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSumUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class MvSum
extends AbstractMultivalueFunction {
    public MvSum(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), t -> t.isNumeric() && EsqlDataTypes.isRepresentable(t), (String)this.sourceText(), null, (String[])new String[]{"numeric"});
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return switch (LocalExecutionPlanner.toElementType(this.field().dataType())) {
            case ElementType.DOUBLE -> dvrCtx -> new MvSumDoubleEvaluator(fieldEval.get(dvrCtx), dvrCtx);
            case ElementType.INT -> dvrCtx -> new MvSumIntEvaluator(this.source(), fieldEval.get(dvrCtx), dvrCtx);
            case ElementType.LONG -> {
                if (this.field().dataType() == DataTypes.UNSIGNED_LONG) {
                    yield dvrCtx -> new MvSumUnsignedLongEvaluator(this.source(), fieldEval.get(dvrCtx), dvrCtx);
                }
                yield dvrCtx -> new MvSumLongEvaluator(this.source(), fieldEval.get(dvrCtx), dvrCtx);
            }
            case ElementType.NULL -> dvrCtx -> EvalOperator.CONSTANT_NULL;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvSum(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvSum::new, (Object)this.field());
    }

    public static void process(CompensatedSum sum, double v) {
        sum.add(v);
    }

    public static double finish(CompensatedSum sum) {
        double value = sum.value();
        sum.reset(0.0, 0.0);
        return value;
    }

    static int process(int current, int v) {
        return Math.addExact(current, v);
    }

    static long process(long current, long v) {
        return Math.addExact(current, v);
    }

    static long processUnsignedLong(long current, long v) {
        return NumericUtils.unsignedLongAddExact((long)current, (long)v);
    }
}

