/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;

public final class MvMinDoubleEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private final DriverContext driverContext;

    public MvMinDoubleEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(field);
        this.driverContext = driverContext;
    }

    @Override
    public String name() {
        return "MvMin";
    }

    @Override
    public Block.Ref evalNullable(Block.Ref ref) {
        if (ref.block().mvSortedAscending()) {
            return this.evalAscendingNullable(ref);
        }
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block16: {
                DoubleBlock v = (DoubleBlock)ref.block();
                int positionCount = v.getPositionCount();
                DoubleBlock.Builder builder = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        if (valueCount == 0) {
                            builder.appendNull();
                            continue;
                        }
                        int first = v.getFirstValueIndex(p);
                        int end = first + valueCount;
                        double value = v.getDouble(first);
                        for (int i = first + 1; i < end; ++i) {
                            double next = v.getDouble(i);
                            value = MvMin.process(value, next);
                        }
                        double result = value;
                        builder.appendDouble(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build());
                    if (builder == null) break block16;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }

    @Override
    public Block.Ref evalNotNullable(Block.Ref ref) {
        if (ref.block().mvSortedAscending()) {
            return this.evalAscendingNotNullable(ref);
        }
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block15: {
                DoubleBlock v = (DoubleBlock)ref.block();
                int positionCount = v.getPositionCount();
                DoubleVector.FixedBuilder builder = DoubleVector.newVectorFixedBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        int first = v.getFirstValueIndex(p);
                        int end = first + valueCount;
                        double value = v.getDouble(first);
                        for (int i = first + 1; i < end; ++i) {
                            double next = v.getDouble(i);
                            value = MvMin.process(value, next);
                        }
                        double result = value;
                        builder.appendDouble(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build().asBlock());
                    if (builder == null) break block15;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }

    private Block.Ref evalAscendingNullable(Block.Ref ref) {
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block14: {
                DoubleBlock v = (DoubleBlock)ref.block();
                int positionCount = v.getPositionCount();
                DoubleBlock.Builder builder = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        if (valueCount == 0) {
                            builder.appendNull();
                            continue;
                        }
                        int first = v.getFirstValueIndex(p);
                        int idx = MvMin.ascendingIndex(valueCount);
                        double result = v.getDouble(first + idx);
                        builder.appendDouble(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build());
                    if (builder == null) break block14;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }

    private Block.Ref evalAscendingNotNullable(Block.Ref ref) {
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block13: {
                DoubleBlock v = (DoubleBlock)ref.block();
                int positionCount = v.getPositionCount();
                DoubleVector.FixedBuilder builder = DoubleVector.newVectorFixedBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        int first = v.getFirstValueIndex(p);
                        int idx = MvMin.ascendingIndex(valueCount);
                        double result = v.getDouble(first + idx);
                        builder.appendDouble(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build().asBlock());
                    if (builder == null) break block13;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }
}

