/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;

public final class MvMedianIntEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private final DriverContext driverContext;

    public MvMedianIntEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(field);
        this.driverContext = driverContext;
    }

    @Override
    public String name() {
        return "MvMedian";
    }

    @Override
    public Block.Ref evalNullable(Block.Ref ref) {
        if (ref.block().mvSortedAscending()) {
            return this.evalAscendingNullable(ref);
        }
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block16: {
                IntBlock v = (IntBlock)ref.block();
                int positionCount = v.getPositionCount();
                IntBlock.Builder builder = IntBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    MvMedian.Ints work = new MvMedian.Ints();
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        if (valueCount == 0) {
                            builder.appendNull();
                            continue;
                        }
                        int first = v.getFirstValueIndex(p);
                        int end = first + valueCount;
                        for (int i = first; i < end; ++i) {
                            int value = v.getInt(i);
                            MvMedian.process(work, value);
                        }
                        int result = MvMedian.finish(work);
                        builder.appendInt(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build());
                    if (builder == null) break block16;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }

    @Override
    public Block.Ref evalNotNullable(Block.Ref ref) {
        if (ref.block().mvSortedAscending()) {
            return this.evalAscendingNotNullable(ref);
        }
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block15: {
                IntBlock v = (IntBlock)ref.block();
                int positionCount = v.getPositionCount();
                IntVector.FixedBuilder builder = IntVector.newVectorFixedBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    MvMedian.Ints work = new MvMedian.Ints();
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        int first = v.getFirstValueIndex(p);
                        int end = first + valueCount;
                        for (int i = first; i < end; ++i) {
                            int value = v.getInt(i);
                            MvMedian.process(work, value);
                        }
                        int result = MvMedian.finish(work);
                        builder.appendInt(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build().asBlock());
                    if (builder == null) break block15;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }

    private Block.Ref evalAscendingNullable(Block.Ref ref) {
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block14: {
                IntBlock v = (IntBlock)ref.block();
                int positionCount = v.getPositionCount();
                IntBlock.Builder builder = IntBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    MvMedian.Ints work = new MvMedian.Ints();
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        if (valueCount == 0) {
                            builder.appendNull();
                            continue;
                        }
                        int first = v.getFirstValueIndex(p);
                        int result = MvMedian.ascending(v, first, valueCount);
                        builder.appendInt(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build());
                    if (builder == null) break block14;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }

    private Block.Ref evalAscendingNotNullable(Block.Ref ref) {
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block13: {
                IntBlock v = (IntBlock)ref.block();
                int positionCount = v.getPositionCount();
                IntVector.FixedBuilder builder = IntVector.newVectorFixedBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    MvMedian.Ints work = new MvMedian.Ints();
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        int first = v.getFirstValueIndex(p);
                        int result = MvMedian.ascending(v, first, valueCount);
                        builder.appendInt(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build().asBlock());
                    if (builder == null) break block13;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }
}

