/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class MvCount
extends AbstractMultivalueFunction {
    public MvCount(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), EsqlDataTypes::isRepresentable, (String)this.sourceText(), null, (String[])new String[]{"representable"});
    }

    @Override
    public DataType dataType() {
        return DataTypes.INTEGER;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return dvrCtx -> new Evaluator(dvrCtx, fieldEval.get(dvrCtx));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvCount(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvCount::new, (Object)this.field());
    }

    private static class Evaluator
    extends AbstractMultivalueFunction.AbstractEvaluator {
        private final DriverContext driverContext;

        protected Evaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field) {
            super(field);
            this.driverContext = driverContext;
        }

        @Override
        protected String name() {
            return "MvCount";
        }

        @Override
        protected Block.Ref evalNullable(Block.Ref ref) {
            try (Block.Ref ref2 = ref;){
                Block.Ref ref3;
                block14: {
                    IntBlock.Builder builder = IntBlock.newBlockBuilder((int)ref.block().getPositionCount(), (BlockFactory)this.driverContext.blockFactory());
                    try {
                        for (int p = 0; p < ref.block().getPositionCount(); ++p) {
                            int valueCount = ref.block().getValueCount(p);
                            if (valueCount == 0) {
                                builder.appendNull();
                                continue;
                            }
                            builder.appendInt(valueCount);
                        }
                        ref3 = Block.Ref.floating((Block)builder.build());
                        if (builder == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    builder.close();
                }
                return ref3;
            }
        }

        @Override
        protected Block.Ref evalNotNullable(Block.Ref ref) {
            try (Block.Ref ref2 = ref;){
                Block.Ref ref3;
                block13: {
                    IntVector.FixedBuilder builder = IntVector.newVectorFixedBuilder((int)ref.block().getPositionCount(), (BlockFactory)this.driverContext.blockFactory());
                    try {
                        for (int p = 0; p < ref.block().getPositionCount(); ++p) {
                            builder.appendInt(ref.block().getValueCount(p));
                        }
                        ref3 = Block.Ref.floating((Block)builder.build().asBlock());
                        if (builder == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    builder.close();
                }
                return ref3;
            }
        }

        @Override
        protected Block.Ref evalSingleValuedNullable(Block.Ref ref) {
            return this.evalNullable(ref);
        }

        @Override
        protected Block.Ref evalSingleValuedNotNullable(Block.Ref ref) {
            try (Block.Ref ref2 = ref;){
                Block.Ref ref3 = Block.Ref.floating((Block)this.driverContext.blockFactory().newConstantIntBlockWith(1, ref.block().getPositionCount()));
                return ref3;
            }
        }
    }
}

