/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvg;

public final class MvAvgLongEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private final DriverContext driverContext;

    public MvAvgLongEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(field);
        this.driverContext = driverContext;
    }

    @Override
    public String name() {
        return "MvAvg";
    }

    @Override
    public Block.Ref evalNullable(Block.Ref ref) {
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block16: {
                LongBlock v = (LongBlock)ref.block();
                int positionCount = v.getPositionCount();
                DoubleBlock.Builder builder = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    CompensatedSum work = new CompensatedSum();
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        if (valueCount == 0) {
                            builder.appendNull();
                            continue;
                        }
                        int first = v.getFirstValueIndex(p);
                        if (valueCount == 1) {
                            long value = v.getLong(first);
                            double result = MvAvg.single(value);
                            builder.appendDouble(result);
                            continue;
                        }
                        int end = first + valueCount;
                        for (int i = first; i < end; ++i) {
                            long value = v.getLong(i);
                            MvAvg.process(work, value);
                        }
                        double result = MvAvg.finish(work, valueCount);
                        builder.appendDouble(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build());
                    if (builder == null) break block16;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }

    @Override
    public Block.Ref evalNotNullable(Block.Ref ref) {
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block15: {
                LongBlock v = (LongBlock)ref.block();
                int positionCount = v.getPositionCount();
                DoubleVector.FixedBuilder builder = DoubleVector.newVectorFixedBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    CompensatedSum work = new CompensatedSum();
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        int first = v.getFirstValueIndex(p);
                        if (valueCount == 1) {
                            long value = v.getLong(first);
                            double result = MvAvg.single(value);
                            builder.appendDouble(result);
                            continue;
                        }
                        int end = first + valueCount;
                        for (int i = first; i < end; ++i) {
                            long value = v.getLong(i);
                            MvAvg.process(work, value);
                        }
                        double result = MvAvg.finish(work, valueCount);
                        builder.appendDouble(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build().asBlock());
                    if (builder == null) break block15;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }

    @Override
    public Block.Ref evalSingleValuedNullable(Block.Ref ref) {
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block15: {
                LongBlock v = (LongBlock)ref.block();
                int positionCount = v.getPositionCount();
                DoubleBlock.Builder builder = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    CompensatedSum work = new CompensatedSum();
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        if (valueCount == 0) {
                            builder.appendNull();
                            continue;
                        }
                        assert (valueCount == 1);
                        int first = v.getFirstValueIndex(p);
                        long value = v.getLong(first);
                        double result = MvAvg.single(value);
                        builder.appendDouble(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build());
                    if (builder == null) break block15;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }

    @Override
    public Block.Ref evalSingleValuedNotNullable(Block.Ref ref) {
        try (Block.Ref ref2 = ref;){
            Block.Ref ref3;
            block14: {
                LongBlock v = (LongBlock)ref.block();
                int positionCount = v.getPositionCount();
                DoubleVector.FixedBuilder builder = DoubleVector.newVectorFixedBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
                try {
                    CompensatedSum work = new CompensatedSum();
                    for (int p = 0; p < positionCount; ++p) {
                        int valueCount = v.getValueCount(p);
                        assert (valueCount == 1);
                        int first = v.getFirstValueIndex(p);
                        long value = v.getLong(first);
                        double result = MvAvg.single(value);
                        builder.appendDouble(result);
                    }
                    ref3 = Block.Ref.floating((Block)builder.build().asBlock());
                    if (builder == null) break block14;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref3;
        }
    }
}

