/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.List;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class MvAvg
extends AbstractMultivalueFunction {
    public MvAvg(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), t -> t.isNumeric() && EsqlDataTypes.isRepresentable(t), (String)this.sourceText(), null, (String[])new String[]{"numeric"});
    }

    @Override
    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return switch (LocalExecutionPlanner.toElementType(this.field().dataType())) {
            case ElementType.DOUBLE -> dvrCtx -> new MvAvgDoubleEvaluator(fieldEval.get(dvrCtx), dvrCtx);
            case ElementType.INT -> dvrCtx -> new MvAvgIntEvaluator(fieldEval.get(dvrCtx), dvrCtx);
            case ElementType.LONG -> {
                if (this.field().dataType() == DataTypes.UNSIGNED_LONG) {
                    yield dvrCtx -> new MvAvgUnsignedLongEvaluator(fieldEval.get(dvrCtx), dvrCtx);
                }
                yield dvrCtx -> new MvAvgLongEvaluator(fieldEval.get(dvrCtx), dvrCtx);
            }
            case ElementType.NULL -> dvrCtx -> EvalOperator.CONSTANT_NULL;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvAvg(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvAvg::new, (Object)this.field());
    }

    public static void process(CompensatedSum sum, double v) {
        sum.add(v);
    }

    public static double finish(CompensatedSum sum, int valueCount) {
        double value = sum.value();
        sum.reset(0.0, 0.0);
        return value / (double)valueCount;
    }

    static void process(CompensatedSum sum, int v) {
        sum.add((double)v);
    }

    static double single(int value) {
        return value;
    }

    static void process(CompensatedSum sum, long v) {
        sum.add((double)v);
    }

    static double single(long value) {
        return value;
    }

    static void processUnsignedLong(CompensatedSum sum, long v) {
        sum.add(NumericUtils.unsignedLongToDouble((long)v));
    }

    static double singleUnsignedLong(long value) {
        return NumericUtils.unsignedLongToDouble((long)value);
    }
}

