/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.function.Function;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class AbstractMultivalueFunction
extends UnaryScalarFunction
implements EvaluatorMapper {
    protected AbstractMultivalueFunction(Source source, Expression field) {
        super(source, field);
    }

    protected abstract EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory var1);

    @Override
    protected final Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return this.resolveFieldType();
    }

    protected abstract Expression.TypeResolution resolveFieldType();

    @Override
    public final Object fold() {
        return EvaluatorMapper.super.fold();
    }

    @Override
    public final EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return this.evaluator(toEvaluator.apply(this.field()));
    }

    public static abstract class AbstractNullableEvaluator
    implements EvalOperator.ExpressionEvaluator {
        protected final EvalOperator.ExpressionEvaluator field;

        protected AbstractNullableEvaluator(EvalOperator.ExpressionEvaluator field) {
            this.field = field;
        }

        protected abstract String name();

        protected abstract Block.Ref evalNullable(Block.Ref var1);

        protected Block.Ref evalSingleValuedNullable(Block.Ref fieldRef) {
            return fieldRef;
        }

        public Block.Ref eval(Page page) {
            Block.Ref fieldRef = this.field.eval(page);
            return fieldRef.block().mayHaveMultivaluedFields() ? this.evalNullable(fieldRef) : this.evalSingleValuedNullable(fieldRef);
        }

        public final String toString() {
            return this.name() + "[field=" + this.field + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.field);
        }
    }

    public static abstract class AbstractEvaluator
    extends AbstractNullableEvaluator {
        protected AbstractEvaluator(EvalOperator.ExpressionEvaluator field) {
            super(field);
        }

        protected abstract Block.Ref evalNotNullable(Block.Ref var1);

        protected Block.Ref evalSingleValuedNotNullable(Block.Ref fieldRef) {
            return fieldRef;
        }

        @Override
        public final Block.Ref eval(Page page) {
            Block.Ref ref = this.field.eval(page);
            if (!ref.block().mayHaveMultivaluedFields()) {
                if (ref.block().mayHaveNulls()) {
                    return this.evalSingleValuedNullable(ref);
                }
                return this.evalSingleValuedNotNullable(ref);
            }
            if (ref.block().mayHaveNulls()) {
                return this.evalNullable(ref);
            }
            return this.evalNotNullable(ref);
        }
    }
}

