/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Round;

public final class RoundDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator val;
    private final EvalOperator.ExpressionEvaluator decimals;
    private final DriverContext driverContext;

    public RoundDoubleEvaluator(EvalOperator.ExpressionEvaluator val, EvalOperator.ExpressionEvaluator decimals, DriverContext driverContext) {
        this.val = val;
        this.decimals = decimals;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref valRef = this.val.eval(page);){
            Block.Ref ref;
            block26: {
                LongVector decimalsVector;
                DoubleVector valVector;
                Block.Ref decimalsRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        LongBlock decimalsBlock;
                        DoubleBlock valBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (valRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        valBlock = (DoubleBlock)valRef.block();
                                        decimalsRef = this.decimals.eval(page);
                                        try {
                                            if (!decimalsRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (decimalsRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (decimalsRef != null) {
                                                try {
                                                    decimalsRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        decimalsRef.close();
                                    }
                                    return ref4;
                                }
                                decimalsBlock = (LongBlock)decimalsRef.block();
                                valVector = valBlock.asVector();
                                if (valVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valBlock, decimalsBlock));
                                if (decimalsRef == null) break block23;
                                decimalsRef.close();
                            }
                            return ref3;
                        }
                        decimalsVector = decimalsBlock.asVector();
                        if (decimalsVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valBlock, decimalsBlock));
                        if (decimalsRef == null) break block25;
                        decimalsRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valVector, decimalsVector).asBlock());
                if (decimalsRef == null) break block26;
                decimalsRef.close();
            }
            return ref;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock valBlock, LongBlock decimalsBlock) {
        try (DoubleBlock.Builder result = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p) || valBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (decimalsBlock.isNull(p) || decimalsBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Round.process(valBlock.getDouble(valBlock.getFirstValueIndex(p)), decimalsBlock.getLong(decimalsBlock.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector valVector, LongVector decimalsVector) {
        try (DoubleVector.Builder result = DoubleVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(Round.process(valVector.getDouble(p), decimalsVector.getLong(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "RoundDoubleEvaluator[val=" + this.val + ", decimals=" + this.decimals + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.val, this.decimals});
    }
}

