/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundDoubleNoDecimalsEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundUnsignedLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.predicate.operator.math.Maths;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Round
extends ScalarFunction
implements OptionalArgument,
EvaluatorMapper {
    private final Expression field;
    private final Expression decimals;

    public Round(Source source, Expression field, Expression decimals) {
        super(source, decimals != null ? Arrays.asList(field, decimals) : Arrays.asList(field));
        this.field = field;
        this.decimals = decimals;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.decimals == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isInteger((Expression)this.decimals, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.field.foldable() && (this.decimals == null || this.decimals.foldable());
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    static double process(double val) {
        return Maths.round((Number)val, (long)0L).doubleValue();
    }

    static int process(int val, long decimals) {
        return Maths.round((long)val, (long)decimals).intValue();
    }

    static long process(long val, long decimals) {
        return Maths.round((long)val, (long)decimals);
    }

    static long processUnsignedLong(long val, long decimals) {
        Number ul = NumericUtils.unsignedLongAsNumber((long)val);
        if (ul instanceof BigInteger) {
            BigInteger bi = (BigInteger)ul;
            BigInteger rounded = Maths.round((BigInteger)bi, (long)decimals);
            BigInteger unsignedLong = NumericUtils.asUnsignedLong((BigInteger)rounded);
            return NumericUtils.asLongUnsigned((BigInteger)unsignedLong);
        }
        return NumericUtils.asLongUnsigned((long)Maths.round((long)ul.longValue(), (long)decimals));
    }

    static double process(double val, long decimals) {
        return Maths.round((Number)val, (long)decimals).doubleValue();
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Round(this.source(), newChildren.get(0), this.decimals() == null ? null : newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Round::new, (Object)this.field(), (Object)this.decimals());
    }

    public Expression field() {
        return this.field;
    }

    public Expression decimals() {
        return this.decimals;
    }

    public DataType dataType() {
        return this.field.dataType();
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        DataType fieldType = this.dataType();
        if (fieldType == DataTypes.DOUBLE) {
            return this.toEvaluator(toEvaluator, RoundDoubleNoDecimalsEvaluator::new, (TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator>)((TriFunction)RoundDoubleEvaluator::new));
        }
        if (fieldType == DataTypes.INTEGER) {
            return this.toEvaluator(toEvaluator, Round.identity(), (TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator>)((TriFunction)RoundIntEvaluator::new));
        }
        if (fieldType == DataTypes.LONG) {
            return this.toEvaluator(toEvaluator, Round.identity(), (TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator>)((TriFunction)RoundLongEvaluator::new));
        }
        if (fieldType == DataTypes.UNSIGNED_LONG) {
            return this.toEvaluator(toEvaluator, Round.identity(), (TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator>)((TriFunction)RoundUnsignedLongEvaluator::new));
        }
        throw EsqlIllegalArgumentException.illegalDataType(fieldType);
    }

    private static <T, U> BiFunction<T, U, T> identity() {
        return (t, u) -> t;
    }

    private EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator, BiFunction<EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> noDecimals, TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> withDecimals) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field());
        if (this.decimals == null) {
            return dvrCtx -> (EvalOperator.ExpressionEvaluator)noDecimals.apply(fieldEvaluator.get(dvrCtx), dvrCtx);
        }
        EvalOperator.ExpressionEvaluator.Factory decimalsEvaluator = Cast.cast(this.decimals().dataType(), DataTypes.LONG, toEvaluator.apply(this.decimals()));
        return dvrCtx -> (EvalOperator.ExpressionEvaluator)withDecimals.apply((Object)fieldEvaluator.get(dvrCtx), (Object)decimalsEvaluator.get(dvrCtx), (Object)dvrCtx);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.decimals);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Round other = (Round)obj;
        return Objects.equals(other.field, this.field) && Objects.equals(other.decimals, this.decimals);
    }
}

