/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Pow;
import org.elasticsearch.xpack.ql.tree.Source;

public final class PowDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator base;
    private final EvalOperator.ExpressionEvaluator exponent;
    private final DriverContext driverContext;

    public PowDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator base, EvalOperator.ExpressionEvaluator exponent, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.base = base;
        this.exponent = exponent;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref baseRef = this.base.eval(page);){
            Block.Ref ref;
            block26: {
                DoubleVector exponentVector;
                DoubleVector baseVector;
                Block.Ref exponentRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        DoubleBlock exponentBlock;
                        DoubleBlock baseBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (baseRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        baseBlock = (DoubleBlock)baseRef.block();
                                        exponentRef = this.exponent.eval(page);
                                        try {
                                            if (!exponentRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (exponentRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (exponentRef != null) {
                                                try {
                                                    exponentRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        exponentRef.close();
                                    }
                                    return ref4;
                                }
                                exponentBlock = (DoubleBlock)exponentRef.block();
                                baseVector = baseBlock.asVector();
                                if (baseVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), baseBlock, exponentBlock));
                                if (exponentRef == null) break block23;
                                exponentRef.close();
                            }
                            return ref3;
                        }
                        exponentVector = exponentBlock.asVector();
                        if (exponentVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), baseBlock, exponentBlock));
                        if (exponentRef == null) break block25;
                        exponentRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), baseVector, exponentVector));
                if (exponentRef == null) break block26;
                exponentRef.close();
            }
            return ref;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock baseBlock, DoubleBlock exponentBlock) {
        try (DoubleBlock.Builder result = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (baseBlock.isNull(p) || baseBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (exponentBlock.isNull(p) || exponentBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendDouble(Pow.process(baseBlock.getDouble(baseBlock.getFirstValueIndex(p)), exponentBlock.getDouble(exponentBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleVector baseVector, DoubleVector exponentVector) {
        try (DoubleBlock.Builder result = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendDouble(Pow.process(baseVector.getDouble(p), exponentVector.getDouble(p)));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "PowDoubleEvaluator[base=" + this.base + ", exponent=" + this.exponent + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.base, this.exponent});
    }
}

