/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.PowDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.PowIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.PowLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Pow
extends ScalarFunction
implements OptionalArgument,
EvaluatorMapper {
    private final Expression base;
    private final Expression exponent;
    private final DataType dataType;

    public Pow(Source source, @Param(name="base", type={"integer", "long", "double"}) Expression base, @Param(name="exponent", type={"integer", "double"}) Expression exponent) {
        super(source, Arrays.asList(base, exponent));
        this.base = base;
        this.exponent = exponent;
        this.dataType = Pow.determineDataType(base, exponent);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.base, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.exponent, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.base.foldable() && this.exponent.foldable();
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    static double process(double base, double exponent) {
        return Pow.validateAsDouble(base, exponent);
    }

    static long processLong(double base, double exponent) {
        return exponent == 1.0 ? Pow.validateAsLong(base) : Pow.validateAsLong(base, exponent);
    }

    static int processInt(double base, double exponent) {
        return exponent == 1.0 ? Pow.validateAsInt(base) : Pow.validateAsInt(base, exponent);
    }

    private static double validateAsDouble(double base, double exponent) {
        double result = Math.pow(base, exponent);
        if (Double.isNaN(result)) {
            throw new ArithmeticException("invalid result: pow(" + base + ", " + exponent + ")");
        }
        return result;
    }

    private static long validateAsLong(double base, double exponent) {
        double result = Math.pow(base, exponent);
        if (Double.isNaN(result)) {
            throw new ArithmeticException("invalid result: pow(" + base + ", " + exponent + ")");
        }
        return Pow.validateAsLong(result);
    }

    private static long validateAsLong(double value) {
        if (Double.compare(value, 9.223372036854776E18) > 0) {
            throw new ArithmeticException("long overflow");
        }
        if (Double.compare(value, -9.223372036854776E18) < 0) {
            throw new ArithmeticException("long overflow");
        }
        return (long)value;
    }

    private static int validateAsInt(double base, double exponent) {
        double result = Math.pow(base, exponent);
        if (Double.isNaN(result)) {
            throw new ArithmeticException("invalid result: pow(" + base + ", " + exponent + ")");
        }
        return Pow.validateAsInt(result);
    }

    private static int validateAsInt(double value) {
        if (Double.compare(value, 2.147483647E9) > 0) {
            throw new ArithmeticException("integer overflow");
        }
        if (Double.compare(value, -2.147483648E9) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Pow(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Pow::new, (Object)this.base(), (Object)this.exponent());
    }

    public Expression base() {
        return this.base;
    }

    public Expression exponent() {
        return this.exponent;
    }

    public DataType dataType() {
        return this.dataType;
    }

    private static DataType determineDataType(Expression base, Expression exponent) {
        if (base.dataType().isRational() || exponent.dataType().isRational()) {
            return DataTypes.DOUBLE;
        }
        if (base.dataType().size() == 8 || exponent.dataType().size() == 8) {
            return DataTypes.LONG;
        }
        return DataTypes.INTEGER;
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory baseEvaluator = toEvaluator.apply(this.base);
        EvalOperator.ExpressionEvaluator.Factory exponentEvaluator = toEvaluator.apply(this.exponent);
        if (this.dataType == DataTypes.DOUBLE) {
            return dvrCtx -> new PowDoubleEvaluator(this.source(), Cast.cast(this.base.dataType(), DataTypes.DOUBLE, baseEvaluator).get(dvrCtx), Cast.cast(this.exponent.dataType(), DataTypes.DOUBLE, exponentEvaluator).get(dvrCtx), dvrCtx);
        }
        if (this.dataType == DataTypes.LONG) {
            return dvrCtx -> new PowLongEvaluator(this.source(), Cast.cast(this.base.dataType(), DataTypes.DOUBLE, baseEvaluator).get(dvrCtx), Cast.cast(this.exponent.dataType(), DataTypes.DOUBLE, exponentEvaluator).get(dvrCtx), dvrCtx);
        }
        return dvrCtx -> new PowIntEvaluator(this.source(), Cast.cast(this.base.dataType(), DataTypes.DOUBLE, baseEvaluator).get(dvrCtx), Cast.cast(this.exponent.dataType(), DataTypes.DOUBLE, exponentEvaluator).get(dvrCtx), dvrCtx);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.exponent);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Pow other = (Pow)obj;
        return Objects.equals(other.base, this.base) && Objects.equals(other.exponent, this.exponent);
    }
}

