/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.IsInfinite;

public final class IsInfiniteEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator val;
    private final DriverContext driverContext;

    public IsInfiniteEvaluator(EvalOperator.ExpressionEvaluator val, DriverContext driverContext) {
        this.val = val;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref valRef = this.val.eval(page);){
            if (valRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            DoubleBlock valBlock = (DoubleBlock)valRef.block();
            DoubleVector valVector = valBlock.asVector();
            if (valVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valVector).asBlock());
            return ref;
        }
    }

    public BooleanBlock eval(int positionCount, DoubleBlock valBlock) {
        try (BooleanBlock.Builder result = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p) || valBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(IsInfinite.process(valBlock.getDouble(valBlock.getFirstValueIndex(p))));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, DoubleVector valVector) {
        try (BooleanVector.Builder result = BooleanVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(IsInfinite.process(valVector.getDouble(p)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "IsInfiniteEvaluator[val=" + this.val + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }
}

