/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;

public final class CastLongToDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;

    public CastLongToDoubleEvaluator(EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.v = v;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref vRef = this.v.eval(page);){
            if (vRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            LongBlock vBlock = (LongBlock)vRef.block();
            LongVector vVector = vBlock.asVector();
            if (vVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), vBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), vVector).asBlock());
            return ref;
        }
    }

    public DoubleBlock eval(int positionCount, LongBlock vBlock) {
        try (DoubleBlock.Builder result = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p) || vBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Cast.castLongToDouble(vBlock.getLong(vBlock.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, LongVector vVector) {
        try (DoubleVector.Builder result = DoubleVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(Cast.castLongToDouble(vVector.getLong(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "CastLongToDoubleEvaluator[v=" + this.v + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }
}

