/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;

public final class CastIntToUnsignedLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;

    public CastIntToUnsignedLongEvaluator(EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.v = v;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref vRef = this.v.eval(page);){
            if (vRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            IntBlock vBlock = (IntBlock)vRef.block();
            IntVector vVector = vBlock.asVector();
            if (vVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), vBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), vVector).asBlock());
            return ref;
        }
    }

    public LongBlock eval(int positionCount, IntBlock vBlock) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p) || vBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendLong(Cast.castIntToUnsignedLong(vBlock.getInt(vBlock.getFirstValueIndex(p))));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, IntVector vVector) {
        try (LongVector.Builder result = LongVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(Cast.castIntToUnsignedLong(vVector.getInt(p)));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "CastIntToUnsignedLongEvaluator[v=" + this.v + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }
}

