/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastIntToDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastIntToLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastIntToUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastLongToDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastLongToUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastUnsignedLongToDoubleEvaluator;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Cast {
    public static EvalOperator.ExpressionEvaluator.Factory cast(DataType current, DataType required, EvalOperator.ExpressionEvaluator.Factory in) {
        if (current == required) {
            return in;
        }
        if (current == DataTypes.NULL || required == DataTypes.NULL) {
            return dvrCtx -> EvalOperator.CONSTANT_NULL;
        }
        if (required == DataTypes.DOUBLE) {
            if (current == DataTypes.LONG) {
                return dvrCtx -> new CastLongToDoubleEvaluator(in.get(dvrCtx), dvrCtx);
            }
            if (current == DataTypes.INTEGER) {
                return dvrCtx -> new CastIntToDoubleEvaluator(in.get(dvrCtx), dvrCtx);
            }
            if (current == DataTypes.UNSIGNED_LONG) {
                return dvrCtx -> new CastUnsignedLongToDoubleEvaluator(in.get(dvrCtx), dvrCtx);
            }
            throw Cast.cantCast(current, required);
        }
        if (required == DataTypes.UNSIGNED_LONG) {
            if (current == DataTypes.LONG) {
                return dvrCtx -> new CastLongToUnsignedLongEvaluator(in.get(dvrCtx), dvrCtx);
            }
            if (current == DataTypes.INTEGER) {
                return dvrCtx -> new CastIntToUnsignedLongEvaluator(in.get(dvrCtx), dvrCtx);
            }
        }
        if (required == DataTypes.LONG) {
            if (current == DataTypes.INTEGER) {
                return dvrCtx -> new CastIntToLongEvaluator(in.get(dvrCtx), dvrCtx);
            }
            throw Cast.cantCast(current, required);
        }
        throw Cast.cantCast(current, required);
    }

    private static EsqlIllegalArgumentException cantCast(DataType current, DataType required) {
        return new EsqlIllegalArgumentException("can't process [" + current.typeName() + " -> " + required.typeName() + "]");
    }

    static long castIntToLong(int v) {
        return v;
    }

    static double castIntToDouble(int v) {
        return v;
    }

    static double castLongToDouble(long v) {
        return v;
    }

    static double castUnsignedLongToDouble(long v) {
        return NumericUtils.unsignedLongToDouble((long)v);
    }

    static long castIntToUnsignedLong(int v) {
        return Cast.castLongToUnsignedLong(v);
    }

    static long castLongToUnsignedLong(long v) {
        if (v < 0L) {
            throw new QlIllegalArgumentException("[" + v + "] out of [unsigned_long] range");
        }
        return v;
    }
}

