/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan2;

public final class Atan2Evaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator y;
    private final EvalOperator.ExpressionEvaluator x;
    private final DriverContext driverContext;

    public Atan2Evaluator(EvalOperator.ExpressionEvaluator y, EvalOperator.ExpressionEvaluator x, DriverContext driverContext) {
        this.y = y;
        this.x = x;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref yRef = this.y.eval(page);){
            Block.Ref ref;
            block26: {
                DoubleVector xVector;
                DoubleVector yVector;
                Block.Ref xRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        DoubleBlock xBlock;
                        DoubleBlock yBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (yRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        yBlock = (DoubleBlock)yRef.block();
                                        xRef = this.x.eval(page);
                                        try {
                                            if (!xRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (xRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (xRef != null) {
                                                try {
                                                    xRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        xRef.close();
                                    }
                                    return ref4;
                                }
                                xBlock = (DoubleBlock)xRef.block();
                                yVector = yBlock.asVector();
                                if (yVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), yBlock, xBlock));
                                if (xRef == null) break block23;
                                xRef.close();
                            }
                            return ref3;
                        }
                        xVector = xBlock.asVector();
                        if (xVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), yBlock, xBlock));
                        if (xRef == null) break block25;
                        xRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), yVector, xVector).asBlock());
                if (xRef == null) break block26;
                xRef.close();
            }
            return ref;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock yBlock, DoubleBlock xBlock) {
        try (DoubleBlock.Builder result = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (yBlock.isNull(p) || yBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (xBlock.isNull(p) || xBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Atan2.process(yBlock.getDouble(yBlock.getFirstValueIndex(p)), xBlock.getDouble(xBlock.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector yVector, DoubleVector xVector) {
        try (DoubleVector.Builder result = DoubleVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(Atan2.process(yVector.getDouble(p), xVector.getDouble(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "Atan2Evaluator[y=" + this.y + ", x=" + this.x + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.y, this.x});
    }
}

