/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan2Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Atan2
extends ScalarFunction
implements EvaluatorMapper {
    private final Expression y;
    private final Expression x;

    @FunctionInfo(returnType={"double"})
    public Atan2(Source source, @Param(name="y", type={"integer", "long", "double", "unsigned_long"}) Expression y, @Param(name="x", type={"integer", "long", "double", "unsigned_long"}) Expression x) {
        super(source, List.of(y, x));
        this.y = y;
        this.x = x;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Atan2(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Atan2::new, (Object)this.y, (Object)this.x);
    }

    static double process(double y, double x) {
        return Math.atan2(y, x);
    }

    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.y, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.x, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory yEval = Cast.cast(this.y.dataType(), DataTypes.DOUBLE, toEvaluator.apply(this.y));
        EvalOperator.ExpressionEvaluator.Factory xEval = Cast.cast(this.x.dataType(), DataTypes.DOUBLE, toEvaluator.apply(this.x));
        return dvrCtx -> new Atan2Evaluator(yEval.get(dvrCtx), xEval.get(dvrCtx), dvrCtx);
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    public Expression y() {
        return this.y;
    }

    public Expression x() {
        return this.x;
    }
}

