/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Abs;

public final class AbsLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator fieldVal;
    private final DriverContext driverContext;

    public AbsLongEvaluator(EvalOperator.ExpressionEvaluator fieldVal, DriverContext driverContext) {
        this.fieldVal = fieldVal;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref fieldValRef = this.fieldVal.eval(page);){
            if (fieldValRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            LongBlock fieldValBlock = (LongBlock)fieldValRef.block();
            LongVector fieldValVector = fieldValBlock.asVector();
            if (fieldValVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), fieldValBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), fieldValVector).asBlock());
            return ref;
        }
    }

    public LongBlock eval(int positionCount, LongBlock fieldValBlock) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (fieldValBlock.isNull(p) || fieldValBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendLong(Abs.process(fieldValBlock.getLong(fieldValBlock.getFirstValueIndex(p))));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector fieldValVector) {
        try (LongVector.Builder result = LongVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(Abs.process(fieldValVector.getLong(p)));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "AbsLongEvaluator[fieldVal=" + this.fieldVal + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.fieldVal);
    }
}

