/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Abs;

public final class AbsIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator fieldVal;
    private final DriverContext driverContext;

    public AbsIntEvaluator(EvalOperator.ExpressionEvaluator fieldVal, DriverContext driverContext) {
        this.fieldVal = fieldVal;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref fieldValRef = this.fieldVal.eval(page);){
            if (fieldValRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            IntBlock fieldValBlock = (IntBlock)fieldValRef.block();
            IntVector fieldValVector = fieldValBlock.asVector();
            if (fieldValVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), fieldValBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), fieldValVector).asBlock());
            return ref;
        }
    }

    public IntBlock eval(int positionCount, IntBlock fieldValBlock) {
        try (IntBlock.Builder result = IntBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (fieldValBlock.isNull(p) || fieldValBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendInt(Abs.process(fieldValBlock.getInt(fieldValBlock.getFirstValueIndex(p))));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector fieldValVector) {
        try (IntVector.Builder result = IntVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendInt(Abs.process(fieldValVector.getInt(p)));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "AbsIntEvaluator[fieldVal=" + this.fieldVal + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.fieldVal);
    }
}

