/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbsDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbsIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbsLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Abs
extends UnaryScalarFunction
implements EvaluatorMapper {
    @FunctionInfo(returnType={"integer", "long", "double", "unsigned_long"})
    public Abs(Source source, @Param(name="n", type={"integer", "long", "double", "unsigned_long"}) Expression n) {
        super(source, n);
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    static double process(double fieldVal) {
        return Math.abs(fieldVal);
    }

    static long process(long fieldVal) {
        return Math.absExact(fieldVal);
    }

    static int process(int fieldVal) {
        return Math.absExact(fieldVal);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        if (this.dataType() == DataTypes.DOUBLE) {
            return dvrCtx -> new AbsDoubleEvaluator(field.get(dvrCtx), dvrCtx);
        }
        if (this.dataType() == DataTypes.UNSIGNED_LONG) {
            return field;
        }
        if (this.dataType() == DataTypes.LONG) {
            return dvrCtx -> new AbsLongEvaluator(field.get(dvrCtx), dvrCtx);
        }
        if (this.dataType() == DataTypes.INTEGER) {
            return dvrCtx -> new AbsIntEvaluator(field.get(dvrCtx), dvrCtx);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.dataType());
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Abs(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Abs::new, (Object)this.field());
    }
}

