/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.ip;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatch;

public final class CIDRMatchEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator ip;
    private final EvalOperator.ExpressionEvaluator[] cidrs;
    private final DriverContext driverContext;

    public CIDRMatchEvaluator(EvalOperator.ExpressionEvaluator ip, EvalOperator.ExpressionEvaluator[] cidrs, DriverContext driverContext) {
        this.ip = ip;
        this.cidrs = cidrs;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block.Ref eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 17[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock ipBlock, BytesRefBlock[] cidrsBlocks) {
        try (BooleanBlock.Builder result = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef ipScratch = new BytesRef();
            BytesRef[] cidrsValues = new BytesRef[this.cidrs.length];
            BytesRef[] cidrsScratch = new BytesRef[this.cidrs.length];
            for (int i = 0; i < this.cidrs.length; ++i) {
                cidrsScratch[i] = new BytesRef();
            }
            block6: for (int p = 0; p < positionCount; ++p) {
                int i;
                if (ipBlock.isNull(p) || ipBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                for (i = 0; i < cidrsBlocks.length; ++i) {
                    if (!cidrsBlocks[i].isNull(p) && cidrsBlocks[i].getValueCount(p) == 1) continue;
                    result.appendNull();
                    continue block6;
                }
                for (i = 0; i < cidrsBlocks.length; ++i) {
                    int o = cidrsBlocks[i].getFirstValueIndex(p);
                    cidrsValues[i] = cidrsBlocks[i].getBytesRef(o, cidrsScratch[i]);
                }
                result.appendBoolean(CIDRMatch.process(ipBlock.getBytesRef(ipBlock.getFirstValueIndex(p), ipScratch), cidrsValues));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector ipVector, BytesRefVector[] cidrsVectors) {
        try (BooleanVector.Builder result = BooleanVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef ipScratch = new BytesRef();
            BytesRef[] cidrsValues = new BytesRef[this.cidrs.length];
            BytesRef[] cidrsScratch = new BytesRef[this.cidrs.length];
            for (int i = 0; i < this.cidrs.length; ++i) {
                cidrsScratch[i] = new BytesRef();
            }
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < cidrsVectors.length; ++i) {
                    cidrsValues[i] = cidrsVectors[i].getBytesRef(p, cidrsScratch[i]);
                }
                result.appendBoolean(CIDRMatch.process(ipVector.getBytesRef(p, ipScratch), cidrsValues));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "CIDRMatchEvaluator[ip=" + this.ip + ", cidrs=" + Arrays.toString(this.cidrs) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.ip, () -> Releasables.close((Releasable[])this.cidrs)});
    }
}

