/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.Now;

public final class NowEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final long now;
    private final DriverContext driverContext;

    public NowEvaluator(long now, DriverContext driverContext) {
        this.now = now;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        return Block.Ref.floating((Block)this.eval(page.getPositionCount()).asBlock());
    }

    public LongVector eval(int positionCount) {
        try (LongVector.Builder result = LongVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(Now.process(this.now));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "NowEvaluator[now=" + this.now + "]";
    }

    public void close() {
    }
}

