/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.NowEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.scalar.ConfigurationFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Now
extends ConfigurationFunction
implements EvaluatorMapper {
    private final long now;

    public Now(Source source, Configuration configuration) {
        super(source, List.of(), configuration);
        this.now = configuration.now() == null ? System.currentTimeMillis() : configuration.now().toInstant().toEpochMilli();
    }

    private Now(Source source, long now) {
        super(source, List.of(), null);
        this.now = now;
    }

    public static Now newInstance(Source source, long now) {
        return new Now(source, now);
    }

    @Override
    public Object fold() {
        return this.now;
    }

    public boolean foldable() {
        return true;
    }

    public DataType dataType() {
        return DataTypes.DATETIME;
    }

    static long process(long now) {
        return now;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return this;
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Now::new, (Object)this.configuration());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return dvrCtx -> new NowEvaluator(this.now, dvrCtx);
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }
}

