/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.BinaryDateTimeFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTruncEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class DateTrunc
extends BinaryDateTimeFunction
implements EvaluatorMapper {
    public DateTrunc(Source source, Expression interval, Expression field) {
        super(source, interval, field);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isDate((Expression)this.timestampField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isType((Expression)this.interval(), EsqlDataTypes::isTemporalAmount, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"dateperiod", "timeduration"}));
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    static long process(long fieldVal, Rounding.Prepared rounding) {
        return rounding.round(fieldVal);
    }

    protected BinaryScalarFunction replaceChildren(Expression newLeft, Expression newRight) {
        return new DateTrunc(this.source(), newLeft, newRight);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DateTrunc::new, (Object)this.interval(), (Object)this.timestampField());
    }

    public Expression interval() {
        return this.left();
    }

    static Rounding.Prepared createRounding(Object interval) {
        return DateTrunc.createRounding(interval, DEFAULT_TZ);
    }

    public static Rounding.Prepared createRounding(Object interval, ZoneId timeZone) {
        if (interval instanceof Period) {
            Period period = (Period)interval;
            return DateTrunc.createRounding(period, timeZone);
        }
        if (interval instanceof Duration) {
            Duration duration = (Duration)interval;
            return DateTrunc.createRounding(duration, timeZone);
        }
        throw new IllegalArgumentException("Time interval is not supported");
    }

    private static Rounding.Prepared createRounding(Period period, ZoneId timeZone) {
        Rounding.Builder rounding;
        if (period == null || period.isNegative() || period.isZero()) {
            throw new IllegalArgumentException("Zero or negative time interval is not supported");
        }
        long periods = period.getUnits().stream().filter(unit -> period.get((TemporalUnit)unit) != 0L).count();
        if (periods != 1L) {
            throw new IllegalArgumentException("Time interval is not supported");
        }
        if (period.getDays() == 1) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.DAY_OF_MONTH);
        } else if (period.getDays() == 7) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR);
        } else if (period.getDays() > 1) {
            rounding = new Rounding.Builder(new TimeValue((long)period.getDays(), TimeUnit.DAYS));
        } else if (period.getMonths() == 1) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.MONTH_OF_YEAR);
        } else if (period.getMonths() == 3) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.QUARTER_OF_YEAR);
        } else if (period.getYears() == 1) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.YEAR_OF_CENTURY);
        } else {
            throw new IllegalArgumentException("Time interval is not supported");
        }
        rounding.timeZone(timeZone);
        return rounding.build().prepareForUnknown();
    }

    private static Rounding.Prepared createRounding(Duration duration, ZoneId timeZone) {
        if (duration == null || duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("Zero or negative time interval is not supported");
        }
        Rounding.Builder rounding = new Rounding.Builder(TimeValue.timeValueMillis((long)duration.toMillis()));
        rounding.timeZone(timeZone);
        return rounding.build().prepareForUnknown();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        Object foldedInterval;
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.timestampField());
        Expression interval = this.interval();
        if (!interval.foldable()) {
            throw new IllegalArgumentException("Function [" + this.sourceText() + "] has invalid interval [" + this.interval().sourceText() + "].");
        }
        try {
            foldedInterval = interval.fold();
            if (foldedInterval == null) {
                throw new IllegalArgumentException("Interval cannot not be null");
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Function [" + this.sourceText() + "] has invalid interval [" + this.interval().sourceText() + "]. " + e.getMessage());
        }
        return DateTrunc.evaluator(fieldEvaluator, DateTrunc.createRounding(foldedInterval, this.zoneId()));
    }

    public static EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEvaluator, Rounding.Prepared rounding) {
        return dvrCtx -> new DateTruncEvaluator(fieldEvaluator.get(dvrCtx), rounding, dvrCtx);
    }
}

