/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParse;
import org.elasticsearch.xpack.ql.tree.Source;

public final class DateParseConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator val;
    private final DateFormatter formatter;
    private final DriverContext driverContext;

    public DateParseConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator val, DateFormatter formatter, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.val = val;
        this.formatter = formatter;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref valRef = this.val.eval(page);){
            if (valRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            BytesRefBlock valBlock = (BytesRefBlock)valRef.block();
            BytesRefVector valVector = valBlock.asVector();
            if (valVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valVector));
            return ref;
        }
    }

    public LongBlock eval(int positionCount, BytesRefBlock valBlock) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef valScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p) || valBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendLong(DateParse.process(valBlock.getBytesRef(valBlock.getFirstValueIndex(p), valScratch), this.formatter));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, BytesRefVector valVector) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef valScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendLong(DateParse.process(valVector.getBytesRef(p, valScratch), this.formatter));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "DateParseConstantEvaluator[val=" + this.val + ", formatter=" + this.formatter + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }
}

