/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormat;

public final class DateFormatEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator val;
    private final EvalOperator.ExpressionEvaluator formatter;
    private final Locale locale;
    private final DriverContext driverContext;

    public DateFormatEvaluator(EvalOperator.ExpressionEvaluator val, EvalOperator.ExpressionEvaluator formatter, Locale locale, DriverContext driverContext) {
        this.val = val;
        this.formatter = formatter;
        this.locale = locale;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref valRef = this.val.eval(page);){
            Block.Ref ref;
            block26: {
                BytesRefVector formatterVector;
                LongVector valVector;
                Block.Ref formatterRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        BytesRefBlock formatterBlock;
                        LongBlock valBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (valRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        valBlock = (LongBlock)valRef.block();
                                        formatterRef = this.formatter.eval(page);
                                        try {
                                            if (!formatterRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (formatterRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (formatterRef != null) {
                                                try {
                                                    formatterRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        formatterRef.close();
                                    }
                                    return ref4;
                                }
                                formatterBlock = (BytesRefBlock)formatterRef.block();
                                valVector = valBlock.asVector();
                                if (valVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valBlock, formatterBlock));
                                if (formatterRef == null) break block23;
                                formatterRef.close();
                            }
                            return ref3;
                        }
                        formatterVector = formatterBlock.asVector();
                        if (formatterVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valBlock, formatterBlock));
                        if (formatterRef == null) break block25;
                        formatterRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valVector, formatterVector).asBlock());
                if (formatterRef == null) break block26;
                formatterRef.close();
            }
            return ref;
        }
    }

    public BytesRefBlock eval(int positionCount, LongBlock valBlock, BytesRefBlock formatterBlock) {
        try (BytesRefBlock.Builder result = BytesRefBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef formatterScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p) || valBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (formatterBlock.isNull(p) || formatterBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBytesRef(DateFormat.process(valBlock.getLong(valBlock.getFirstValueIndex(p)), formatterBlock.getBytesRef(formatterBlock.getFirstValueIndex(p), formatterScratch), this.locale));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, LongVector valVector, BytesRefVector formatterVector) {
        try (BytesRefVector.Builder result = BytesRefVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef formatterScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBytesRef(DateFormat.process(valVector.getLong(p), formatterVector.getBytesRef(p, formatterScratch), this.locale));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "DateFormatEvaluator[val=" + this.val + ", formatter=" + this.formatter + ", locale=" + this.locale + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.val, this.formatter});
    }
}

