/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormat;

public final class DateFormatConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator val;
    private final DateFormatter formatter;
    private final DriverContext driverContext;

    public DateFormatConstantEvaluator(EvalOperator.ExpressionEvaluator val, DateFormatter formatter, DriverContext driverContext) {
        this.val = val;
        this.formatter = formatter;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref valRef = this.val.eval(page);){
            if (valRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            LongBlock valBlock = (LongBlock)valRef.block();
            LongVector valVector = valBlock.asVector();
            if (valVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valVector).asBlock());
            return ref;
        }
    }

    public BytesRefBlock eval(int positionCount, LongBlock valBlock) {
        try (BytesRefBlock.Builder result = BytesRefBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p) || valBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBytesRef(DateFormat.process(valBlock.getLong(valBlock.getFirstValueIndex(p)), this.formatter));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, LongVector valVector) {
        try (BytesRefVector.Builder result = BytesRefVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBytesRef(DateFormat.process(valVector.getLong(p), this.formatter));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "DateFormatConstantEvaluator[val=" + this.val + ", formatter=" + this.formatter + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }
}

