/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormatConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormatEvaluator;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ConfigurationFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.DateUtils;

public class DateFormat
extends ConfigurationFunction
implements OptionalArgument,
EvaluatorMapper {
    private final Expression field;
    private final Expression format;

    public DateFormat(Source source, Expression first, Expression second, Configuration configuration) {
        super(source, second != null ? List.of(first, second) : List.of(first), configuration);
        this.field = second != null ? second : first;
        this.format = second != null ? first : null;
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isDate((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)(this.format == null ? TypeResolutions.ParamOrdinal.FIRST : TypeResolutions.ParamOrdinal.SECOND));
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.format != null && (resolution = TypeResolutions.isStringAndExact((Expression)this.format, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST)).unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public boolean foldable() {
        return this.field.foldable() && (this.format == null || this.format.foldable());
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    static BytesRef process(long val, DateFormatter formatter) {
        return new BytesRef((CharSequence)formatter.formatMillis(val));
    }

    static BytesRef process(long val, BytesRef formatter, Locale locale) {
        return DateFormat.process(val, DateFormat.toFormatter(formatter, locale));
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        if (this.format == null) {
            return dvrCtx -> new DateFormatConstantEvaluator(fieldEvaluator.get(dvrCtx), DateUtils.UTC_DATE_TIME_FORMATTER, dvrCtx);
        }
        if (this.format.dataType() != DataTypes.KEYWORD) {
            throw new IllegalArgumentException("unsupported data type for format [" + this.format.dataType() + "]");
        }
        if (this.format.foldable()) {
            DateFormatter formatter = DateFormat.toFormatter(this.format.fold(), ((EsqlConfiguration)this.configuration()).locale());
            return dvrCtx -> new DateFormatConstantEvaluator(fieldEvaluator.get(dvrCtx), formatter, dvrCtx);
        }
        EvalOperator.ExpressionEvaluator.Factory formatEvaluator = toEvaluator.apply(this.format);
        return dvrCtx -> new DateFormatEvaluator(fieldEvaluator.get(dvrCtx), formatEvaluator.get(dvrCtx), ((EsqlConfiguration)this.configuration()).locale(), dvrCtx);
    }

    private static DateFormatter toFormatter(Object format, Locale locale) {
        DateFormatter result = format == null ? DateUtils.UTC_DATE_TIME_FORMATTER : DateFormatter.forPattern((String)((BytesRef)format).utf8ToString());
        return result.withLocale(locale);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateFormat(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null, this.configuration());
    }

    protected NodeInfo<? extends Expression> info() {
        Expression first = this.format != null ? this.format : this.field;
        Expression second = this.format != null ? this.field : null;
        return NodeInfo.create((Node)this, DateFormat::new, (Object)first, (Object)second, (Object)this.configuration());
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }
}

