/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtract;
import org.elasticsearch.xpack.ql.tree.Source;

public final class DateExtractEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator value;
    private final EvalOperator.ExpressionEvaluator chronoField;
    private final ZoneId zone;
    private final DriverContext driverContext;

    public DateExtractEvaluator(Source source, EvalOperator.ExpressionEvaluator value, EvalOperator.ExpressionEvaluator chronoField, ZoneId zone, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.value = value;
        this.chronoField = chronoField;
        this.zone = zone;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref valueRef = this.value.eval(page);){
            Block.Ref ref;
            block26: {
                BytesRefVector chronoFieldVector;
                LongVector valueVector;
                Block.Ref chronoFieldRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        BytesRefBlock chronoFieldBlock;
                        LongBlock valueBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (valueRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        valueBlock = (LongBlock)valueRef.block();
                                        chronoFieldRef = this.chronoField.eval(page);
                                        try {
                                            if (!chronoFieldRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (chronoFieldRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (chronoFieldRef != null) {
                                                try {
                                                    chronoFieldRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        chronoFieldRef.close();
                                    }
                                    return ref4;
                                }
                                chronoFieldBlock = (BytesRefBlock)chronoFieldRef.block();
                                valueVector = valueBlock.asVector();
                                if (valueVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valueBlock, chronoFieldBlock));
                                if (chronoFieldRef == null) break block23;
                                chronoFieldRef.close();
                            }
                            return ref3;
                        }
                        chronoFieldVector = chronoFieldBlock.asVector();
                        if (chronoFieldVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valueBlock, chronoFieldBlock));
                        if (chronoFieldRef == null) break block25;
                        chronoFieldRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valueVector, chronoFieldVector));
                if (chronoFieldRef == null) break block26;
                chronoFieldRef.close();
            }
            return ref;
        }
    }

    public LongBlock eval(int positionCount, LongBlock valueBlock, BytesRefBlock chronoFieldBlock) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef chronoFieldScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (valueBlock.isNull(p) || valueBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (chronoFieldBlock.isNull(p) || chronoFieldBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendLong(DateExtract.process(valueBlock.getLong(valueBlock.getFirstValueIndex(p)), chronoFieldBlock.getBytesRef(chronoFieldBlock.getFirstValueIndex(p), chronoFieldScratch), this.zone));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongVector valueVector, BytesRefVector chronoFieldVector) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef chronoFieldScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendLong(DateExtract.process(valueVector.getLong(p), chronoFieldVector.getBytesRef(p, chronoFieldScratch), this.zone));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "DateExtractEvaluator[value=" + this.value + ", chronoField=" + this.chronoField + ", zone=" + this.zone + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.value, this.chronoField});
    }
}

