/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import java.time.temporal.ChronoField;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtract;

public final class DateExtractConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator value;
    private final ChronoField chronoField;
    private final ZoneId zone;
    private final DriverContext driverContext;

    public DateExtractConstantEvaluator(EvalOperator.ExpressionEvaluator value, ChronoField chronoField, ZoneId zone, DriverContext driverContext) {
        this.value = value;
        this.chronoField = chronoField;
        this.zone = zone;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref valueRef = this.value.eval(page);){
            if (valueRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            LongBlock valueBlock = (LongBlock)valueRef.block();
            LongVector valueVector = valueBlock.asVector();
            if (valueVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valueBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valueVector).asBlock());
            return ref;
        }
    }

    public LongBlock eval(int positionCount, LongBlock valueBlock) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (valueBlock.isNull(p) || valueBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendLong(DateExtract.process(valueBlock.getLong(valueBlock.getFirstValueIndex(p)), this.chronoField, this.zone));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector valueVector) {
        try (LongVector.Builder result = LongVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(DateExtract.process(valueVector.getLong(p), this.chronoField, this.zone));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "DateExtractConstantEvaluator[value=" + this.value + ", chronoField=" + this.chronoField + ", zone=" + this.zone + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.value);
    }
}

