/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToVersionFromStringEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.versionfield.Version;

public class ToVersion
extends AbstractConvertFunction {
    private static final Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.VERSION, (fieldEval, source, driverContext) -> fieldEval), Map.entry(DataTypes.KEYWORD, ToVersionFromStringEvaluator::new), Map.entry(DataTypes.TEXT, ToVersionFromStringEvaluator::new));

    public ToVersion(Source source, @Param(name="v", type={"keyword", "text", "version"}) Expression v) {
        super(source, v);
    }

    @Override
    protected Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> evaluators() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.VERSION;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToVersion(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToVersion::new, (Object)this.field());
    }

    static BytesRef fromKeyword(BytesRef asString) {
        return new Version(asString.utf8ToString()).toBytesRef();
    }
}

