/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;
import org.elasticsearch.xpack.ql.tree.Source;

public final class ToUnsignedLongFromLongEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToUnsignedLongFromLongEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToUnsignedLongFromLong";
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantLongBlockWith(ToUnsignedLongFromLongEvaluator.evalValue(vector, 0), positionCount);
            }
            catch (Exception e) {
                this.registerException(e);
                return Block.constantNullBlock((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
            }
        }
        LongBlock.Builder builder = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
        for (int p = 0; p < positionCount; ++p) {
            try {
                builder.appendLong(ToUnsignedLongFromLongEvaluator.evalValue(vector, p));
                continue;
            }
            catch (Exception e) {
                this.registerException(e);
                builder.appendNull();
            }
        }
        return builder.build();
    }

    private static long evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return ToUnsignedLong.fromLong(value);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (LongBlock.Builder builder = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        long value = ToUnsignedLongFromLongEvaluator.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendLong(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (Exception e) {
                        this.registerException(e);
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private static long evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return ToUnsignedLong.fromLong(value);
    }
}

