/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromStringEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class ToUnsignedLong
extends AbstractConvertFunction {
    private static final Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> EVALUATORS = Map.of(DataTypes.UNSIGNED_LONG, (fieldEval, source, driverContext) -> fieldEval, DataTypes.DATETIME, ToUnsignedLongFromLongEvaluator::new, DataTypes.BOOLEAN, ToUnsignedLongFromBooleanEvaluator::new, DataTypes.KEYWORD, ToUnsignedLongFromStringEvaluator::new, DataTypes.DOUBLE, ToUnsignedLongFromDoubleEvaluator::new, DataTypes.LONG, ToUnsignedLongFromLongEvaluator::new, DataTypes.INTEGER, ToUnsignedLongFromIntEvaluator::new);

    public ToUnsignedLong(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> evaluators() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.UNSIGNED_LONG;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToUnsignedLong(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToUnsignedLong::new, (Object)this.field());
    }

    static long fromBoolean(boolean bool) {
        return bool ? NumericUtils.ONE_AS_UNSIGNED_LONG : NumericUtils.ZERO_AS_UNSIGNED_LONG;
    }

    static long fromKeyword(BytesRef in) {
        String asString = in.utf8ToString();
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((String)asString));
    }

    static long fromDouble(double dbl) {
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((Double)dbl));
    }

    static long fromLong(long lng) {
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((Long)lng));
    }

    static long fromInt(int i) {
        return ToUnsignedLong.fromLong(i);
    }
}

