/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromDatetimeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromIPEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromVersionEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.DateUtils;
import org.elasticsearch.xpack.ql.util.NumericUtils;
import org.elasticsearch.xpack.versionfield.Version;

public class ToString
extends AbstractConvertFunction
implements EvaluatorMapper {
    private static final Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> EVALUATORS = Map.of(DataTypes.KEYWORD, (fieldEval, source, driverContext) -> fieldEval, DataTypes.BOOLEAN, ToStringFromBooleanEvaluator::new, DataTypes.DATETIME, ToStringFromDatetimeEvaluator::new, DataTypes.IP, ToStringFromIPEvaluator::new, DataTypes.DOUBLE, ToStringFromDoubleEvaluator::new, DataTypes.LONG, ToStringFromLongEvaluator::new, DataTypes.INTEGER, ToStringFromIntEvaluator::new, DataTypes.TEXT, (fieldEval, source, driverContext) -> fieldEval, DataTypes.VERSION, ToStringFromVersionEvaluator::new, DataTypes.UNSIGNED_LONG, ToStringFromUnsignedLongEvaluator::new);

    public ToString(Source source, @Param(name="v", type={"unsigned_long", "date", "boolean", "double", "ip", "text", "integer", "keyword", "version", "long"}) Expression v) {
        super(source, v);
    }

    @Override
    protected Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> evaluators() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToString(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToString::new, (Object)this.field());
    }

    static BytesRef fromBoolean(boolean bool) {
        return new BytesRef((CharSequence)String.valueOf(bool));
    }

    static BytesRef fromIP(BytesRef ip) {
        return new BytesRef((CharSequence)DocValueFormat.IP.format(ip));
    }

    static BytesRef fromDatetime(long datetime) {
        return new BytesRef((CharSequence)DateUtils.UTC_DATE_TIME_FORMATTER.formatMillis(datetime));
    }

    static BytesRef fromDouble(double dbl) {
        return new BytesRef((CharSequence)String.valueOf(dbl));
    }

    static BytesRef fromDouble(long lng) {
        return new BytesRef((CharSequence)String.valueOf(lng));
    }

    static BytesRef fromDouble(int integer) {
        return new BytesRef((CharSequence)String.valueOf(integer));
    }

    static BytesRef fromVersion(BytesRef version) {
        return new BytesRef((CharSequence)new Version(version).toString());
    }

    static BytesRef fromUnsignedLong(long lng) {
        return new BytesRef((CharSequence)NumericUtils.unsignedLongAsNumber((long)lng).toString());
    }
}

