/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class ToLong
extends AbstractConvertFunction {
    private static final Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> EVALUATORS = Map.of(DataTypes.LONG, (fieldEval, source, driverContext) -> fieldEval, DataTypes.DATETIME, (fieldEval, source, driverContext) -> fieldEval, DataTypes.BOOLEAN, ToLongFromBooleanEvaluator::new, DataTypes.KEYWORD, ToLongFromStringEvaluator::new, DataTypes.DOUBLE, ToLongFromDoubleEvaluator::new, DataTypes.UNSIGNED_LONG, ToLongFromUnsignedLongEvaluator::new, DataTypes.INTEGER, ToLongFromIntEvaluator::new);

    public ToLong(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> evaluators() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.LONG;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToLong(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToLong::new, (Object)this.field());
    }

    static long fromBoolean(boolean bool) {
        return bool ? 1L : 0L;
    }

    static long fromKeyword(BytesRef in) {
        String asString = in.utf8ToString();
        try {
            return Long.parseLong(asString);
        }
        catch (NumberFormatException nfe) {
            try {
                return ToLong.fromDouble(Double.parseDouble(asString));
            }
            catch (Exception e) {
                throw nfe;
            }
        }
    }

    static long fromDouble(double dbl) {
        return DataTypeConverter.safeDoubleToLong((double)dbl);
    }

    static long fromUnsignedLong(long ul) {
        return DataTypeConverter.safeToLong((Number)NumericUtils.unsignedLongAsNumber((long)ul));
    }

    static long fromInt(int i) {
        return i;
    }
}

