/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ToInteger
extends AbstractConvertFunction {
    private static final Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> EVALUATORS = Map.of(DataTypes.INTEGER, (fieldEval, source, driverContext) -> fieldEval, DataTypes.BOOLEAN, ToIntegerFromBooleanEvaluator::new, DataTypes.DATETIME, ToIntegerFromLongEvaluator::new, DataTypes.KEYWORD, ToIntegerFromStringEvaluator::new, DataTypes.DOUBLE, ToIntegerFromDoubleEvaluator::new, DataTypes.UNSIGNED_LONG, ToIntegerFromUnsignedLongEvaluator::new, DataTypes.LONG, ToIntegerFromLongEvaluator::new);

    public ToInteger(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> evaluators() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.INTEGER;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToInteger(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToInteger::new, (Object)this.field());
    }

    static int fromBoolean(boolean bool) {
        return bool ? 1 : 0;
    }

    static int fromKeyword(BytesRef in) {
        String asString = in.utf8ToString();
        try {
            return Integer.parseInt(asString);
        }
        catch (NumberFormatException nfe) {
            try {
                return ToInteger.fromDouble(Double.parseDouble(asString));
            }
            catch (Exception e) {
                throw nfe;
            }
        }
    }

    static int fromDouble(double dbl) {
        return ToInteger.fromLong(DataTypeConverter.safeDoubleToLong((double)dbl));
    }

    static int fromUnsignedLong(long lng) {
        return ToInteger.fromLong(ToLong.fromUnsignedLong(lng));
    }

    static int fromLong(long lng) {
        return DataTypeConverter.safeToInt((long)lng);
    }
}

