/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class ToDouble
extends AbstractConvertFunction {
    private static final Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> EVALUATORS = Map.of(DataTypes.DOUBLE, (fieldEval, source, driverContext) -> fieldEval, DataTypes.BOOLEAN, ToDoubleFromBooleanEvaluator::new, DataTypes.DATETIME, ToDoubleFromLongEvaluator::new, DataTypes.KEYWORD, ToDoubleFromStringEvaluator::new, DataTypes.UNSIGNED_LONG, ToDoubleFromUnsignedLongEvaluator::new, DataTypes.LONG, ToDoubleFromLongEvaluator::new, DataTypes.INTEGER, ToDoubleFromIntEvaluator::new);

    public ToDouble(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> evaluators() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToDouble(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToDouble::new, (Object)this.field());
    }

    static double fromBoolean(boolean bool) {
        return bool ? 1.0 : 0.0;
    }

    static double fromKeyword(BytesRef in) {
        return Double.parseDouble(in.utf8ToString());
    }

    static double fromUnsignedLong(long l) {
        return NumericUtils.unsignedLongAsNumber((long)l).doubleValue();
    }

    static double fromLong(long l) {
        return l;
    }

    static double fromInt(int i) {
        return i;
    }
}

