/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBoolean;
import org.elasticsearch.xpack.ql.tree.Source;

public final class ToBooleanFromLongEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToBooleanFromLongEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToBooleanFromLong";
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantBooleanBlockWith(ToBooleanFromLongEvaluator.evalValue(vector, 0), positionCount);
            }
            catch (Exception e) {
                this.registerException(e);
                return Block.constantNullBlock((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
            }
        }
        BooleanBlock.Builder builder = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());
        for (int p = 0; p < positionCount; ++p) {
            try {
                builder.appendBoolean(ToBooleanFromLongEvaluator.evalValue(vector, p));
                continue;
            }
            catch (Exception e) {
                this.registerException(e);
                builder.appendNull();
            }
        }
        return builder.build();
    }

    private static boolean evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return ToBoolean.fromLong(value);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (BooleanBlock.Builder builder = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        boolean value = ToBooleanFromLongEvaluator.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendBoolean(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (Exception e) {
                        this.registerException(e);
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private static boolean evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return ToBoolean.fromLong(value);
    }
}

