/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class ToBoolean
extends AbstractConvertFunction {
    private static final Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> EVALUATORS = Map.of(DataTypes.BOOLEAN, (fieldEval, source, driverContext) -> fieldEval, DataTypes.KEYWORD, ToBooleanFromStringEvaluator::new, DataTypes.DOUBLE, ToBooleanFromDoubleEvaluator::new, DataTypes.LONG, ToBooleanFromLongEvaluator::new, DataTypes.UNSIGNED_LONG, ToBooleanFromUnsignedLongEvaluator::new, DataTypes.INTEGER, ToBooleanFromIntEvaluator::new);

    public ToBoolean(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> evaluators() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToBoolean(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToBoolean::new, (Object)this.field());
    }

    static boolean fromKeyword(BytesRef keyword) {
        return Boolean.parseBoolean(keyword.utf8ToString());
    }

    static boolean fromDouble(double d) {
        return d != 0.0;
    }

    static boolean fromLong(long l) {
        return l != 0L;
    }

    static boolean fromUnsignedLong(long ul) {
        Number n = NumericUtils.unsignedLongAsNumber((long)ul);
        return n instanceof BigInteger || n.longValue() != 0L;
    }

    static boolean fromInt(int i) {
        return ToBoolean.fromLong(i);
    }
}

