/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public abstract class AbstractConvertFunction
extends UnaryScalarFunction
implements EvaluatorMapper {
    protected AbstractConvertFunction(Source source, Expression field) {
        super(source, field);
    }

    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        DataType sourceType = this.field().dataType();
        TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator> evaluator = this.evaluators().get(sourceType);
        if (evaluator == null) {
            throw EsqlIllegalArgumentException.illegalDataType(sourceType);
        }
        return dvrCtx -> (EvalOperator.ExpressionEvaluator)evaluator.apply((Object)fieldEval.get(dvrCtx), (Object)this.source(), (Object)dvrCtx);
    }

    @Override
    protected final Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.field(), this.evaluators()::containsKey, (String)this.sourceText(), null, (String[])((String[])this.evaluators().keySet().stream().map(dt -> dt.name().toLowerCase(Locale.ROOT)).sorted().toArray(String[]::new)));
    }

    protected abstract Map<DataType, TriFunction<EvalOperator.ExpressionEvaluator, Source, DriverContext, EvalOperator.ExpressionEvaluator>> evaluators();

    @Override
    public final Object fold() {
        return EvaluatorMapper.super.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return this.evaluator(toEvaluator.apply(this.field()));
    }

    public static abstract class AbstractEvaluator
    implements EvalOperator.ExpressionEvaluator {
        private static final Log logger = LogFactory.getLog(AbstractEvaluator.class);
        protected final DriverContext driverContext;
        private final EvalOperator.ExpressionEvaluator fieldEvaluator;
        private final Warnings warnings;

        protected AbstractEvaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field, Source source) {
            this.driverContext = driverContext;
            this.fieldEvaluator = field;
            this.warnings = new Warnings(source);
        }

        protected abstract String name();

        protected abstract Block evalBlock(Block var1);

        protected abstract Block evalVector(Vector var1);

        public Block.Ref eval(Page page) {
            try (Block.Ref ref = this.fieldEvaluator.eval(page);){
                if (ref.block().areAllValuesNull()) {
                    Block.Ref ref2 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                    return ref2;
                }
                Vector vector = ref.block().asVector();
                Block.Ref ref3 = Block.Ref.floating((Block)(vector == null ? this.evalBlock(ref.block()) : this.evalVector(vector)));
                return ref3;
            }
        }

        protected final void registerException(Exception exception) {
            logger.trace((Object)"conversion failure", (Throwable)exception);
            this.warnings.registerException(exception);
        }

        public final String toString() {
            return this.name() + "Evaluator[field=" + this.fieldEvaluator + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.fieldEvaluator);
        }
    }
}

