/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.Arrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Least;

public final class LeastIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;

    public LeastIntEvaluator(EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.values = values;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        Block.Ref[] valuesRefs = new Block.Ref[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesRefs);){
            IntBlock[] valuesBlocks = new IntBlock[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesRefs[i] = this.values[i].eval(page);
                Block block = valuesRefs[i].block();
                if (block.areAllValuesNull()) {
                    Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                    return ref;
                }
                valuesBlocks[i] = (IntBlock)block;
            }
            IntVector[] valuesVectors = new IntVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valuesBlocks));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valuesVectors).asBlock());
            return ref;
        }
    }

    public IntBlock eval(int positionCount, IntBlock[] valuesBlocks) {
        try (IntBlock.Builder result = IntBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            int[] valuesValues = new int[this.values.length];
            block5: for (int p = 0; p < positionCount; ++p) {
                int i;
                for (i = 0; i < valuesBlocks.length; ++i) {
                    if (!valuesBlocks[i].isNull(p) && valuesBlocks[i].getValueCount(p) == 1) continue;
                    result.appendNull();
                    continue block5;
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getInt(o);
                }
                result.appendInt(Least.process(valuesValues));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector[] valuesVectors) {
        try (IntVector.Builder result = IntVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            int[] valuesValues = new int[this.values.length];
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getInt(p);
                }
                result.appendInt(Least.process(valuesValues));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "LeastIntEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException(() -> Releasables.close((Releasable[])this.values));
    }
}

