/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.Arrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Least;

public final class LeastDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;

    public LeastDoubleEvaluator(EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.values = values;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        Block.Ref[] valuesRefs = new Block.Ref[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesRefs);){
            DoubleBlock[] valuesBlocks = new DoubleBlock[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesRefs[i] = this.values[i].eval(page);
                Block block = valuesRefs[i].block();
                if (block.areAllValuesNull()) {
                    Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                    return ref;
                }
                valuesBlocks[i] = (DoubleBlock)block;
            }
            DoubleVector[] valuesVectors = new DoubleVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valuesBlocks));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), valuesVectors).asBlock());
            return ref;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock[] valuesBlocks) {
        try (DoubleBlock.Builder result = DoubleBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            double[] valuesValues = new double[this.values.length];
            block5: for (int p = 0; p < positionCount; ++p) {
                int i;
                for (i = 0; i < valuesBlocks.length; ++i) {
                    if (!valuesBlocks[i].isNull(p) && valuesBlocks[i].getValueCount(p) == 1) continue;
                    result.appendNull();
                    continue block5;
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getDouble(o);
                }
                result.appendDouble(Least.process(valuesValues));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector[] valuesVectors) {
        try (DoubleVector.Builder result = DoubleVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            double[] valuesValues = new double[this.values.length];
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getDouble(p);
                }
                result.appendDouble(Least.process(valuesValues));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "LeastDoubleEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException(() -> Releasables.close((Releasable[])this.values));
    }
}

