/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Greatest
extends ScalarFunction
implements EvaluatorMapper,
OptionalArgument {
    private DataType dataType;

    public Greatest(Source source, @Param(name="first", type={"integer", "long", "double", "boolean", "keyword", "text", "ip", "version"}) Expression first, @Param(name="rest", type={"integer", "long", "double", "boolean", "keyword", "text", "ip", "version"}) List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        for (int position = 0; position < this.children().size(); ++position) {
            Expression child = (Expression)this.children().get(position);
            if (this.dataType == null || this.dataType == DataTypes.NULL) {
                this.dataType = child.dataType();
                continue;
            }
            Expression.TypeResolution resolution = TypeResolutions.isType((Expression)child, t -> t == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException();
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Greatest(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Greatest::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        List<EvalOperator.ExpressionEvaluator.Factory> suppliers = this.children().stream().map(toEvaluator).toList();
        if (this.dataType == DataTypes.BOOLEAN) {
            return dvrCtx -> new GreatestBooleanEvaluator((EvalOperator.ExpressionEvaluator[])suppliers.stream().map(es -> es.get(dvrCtx)).map(ev -> new MvMaxBooleanEvaluator((EvalOperator.ExpressionEvaluator)ev, dvrCtx)).toArray(EvalOperator.ExpressionEvaluator[]::new), dvrCtx);
        }
        if (this.dataType == DataTypes.DOUBLE) {
            return dvrCtx -> new GreatestDoubleEvaluator((EvalOperator.ExpressionEvaluator[])suppliers.stream().map(es -> es.get(dvrCtx)).map(ev -> new MvMaxDoubleEvaluator((EvalOperator.ExpressionEvaluator)ev, dvrCtx)).toArray(EvalOperator.ExpressionEvaluator[]::new), dvrCtx);
        }
        if (this.dataType == DataTypes.INTEGER) {
            return dvrCtx -> new GreatestIntEvaluator((EvalOperator.ExpressionEvaluator[])suppliers.stream().map(es -> es.get(dvrCtx)).map(ev -> new MvMaxIntEvaluator((EvalOperator.ExpressionEvaluator)ev, dvrCtx)).toArray(EvalOperator.ExpressionEvaluator[]::new), dvrCtx);
        }
        if (this.dataType == DataTypes.LONG) {
            return dvrCtx -> new GreatestLongEvaluator((EvalOperator.ExpressionEvaluator[])suppliers.stream().map(es -> es.get(dvrCtx)).map(ev -> new MvMaxLongEvaluator((EvalOperator.ExpressionEvaluator)ev, dvrCtx)).toArray(EvalOperator.ExpressionEvaluator[]::new), dvrCtx);
        }
        if (this.dataType == DataTypes.KEYWORD || this.dataType == DataTypes.TEXT || this.dataType == DataTypes.IP || this.dataType == DataTypes.VERSION || this.dataType == DataTypes.UNSUPPORTED) {
            return dvrCtx -> new GreatestBytesRefEvaluator((EvalOperator.ExpressionEvaluator[])suppliers.stream().map(es -> es.get(dvrCtx)).map(ev -> new MvMaxBytesRefEvaluator((EvalOperator.ExpressionEvaluator)ev, dvrCtx)).toArray(EvalOperator.ExpressionEvaluator[]::new), dvrCtx);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.dataType);
    }

    static boolean process(boolean[] values) {
        for (boolean v : values) {
            if (!v) continue;
            return true;
        }
        return false;
    }

    static BytesRef process(BytesRef[] values) {
        BytesRef max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = max.compareTo(values[i]) > 0 ? max : values[i];
        }
        return max;
    }

    static int process(int[] values) {
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    static long process(long[] values) {
        long max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    static double process(double[] values) {
        double max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }
}

