/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Case
extends ScalarFunction
implements EvaluatorMapper {
    private final List<Condition> conditions;
    private final Expression elseValue;
    private DataType dataType;

    public Case(Source source, Expression first, List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
        int conditionCount = this.children().size() / 2;
        this.conditions = new ArrayList<Condition>(conditionCount);
        for (int c = 0; c < conditionCount; ++c) {
            this.conditions.add(new Condition((Expression)this.children().get(c * 2), (Expression)this.children().get(c * 2 + 1)));
        }
        this.elseValue = this.children().size() % 2 == 0 ? new Literal(source, null, DataTypes.NULL) : (Expression)this.children().get(this.children().size() - 1);
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        if (this.children().size() < 2) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"expected at least two arguments in [{}] but got {}", (Object[])new Object[]{this.sourceText(), this.children().size()}));
        }
        for (int c = 0; c < this.conditions.size(); ++c) {
            Condition condition = this.conditions.get(c);
            Expression.TypeResolution resolution = TypeResolutions.isBoolean((Expression)condition.condition, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)(c * 2)));
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = this.resolveValueType(condition.value, c * 2 + 1);
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return this.resolveValueType(this.elseValue, this.conditions.size() * 2);
    }

    private Expression.TypeResolution resolveValueType(Expression value, int position) {
        if (this.dataType == null || this.dataType == DataTypes.NULL) {
            this.dataType = value.dataType();
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return TypeResolutions.isType((Expression)value, t -> t == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
    }

    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Case(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Case::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        for (Condition condition : this.conditions) {
            if (!condition.condition.foldable()) {
                return false;
            }
            Boolean b = (Boolean)condition.condition.fold();
            if (b == null || !b.booleanValue()) continue;
            return condition.value.foldable();
        }
        return this.elseValue.foldable();
    }

    @Override
    public Object fold() {
        for (Condition condition : this.conditions) {
            Boolean b = (Boolean)condition.condition.fold();
            if (b == null || !b.booleanValue()) continue;
            return condition.value.fold();
        }
        return this.elseValue.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        List<ConditionEvaluatorSupplier> conditionsEval = this.conditions.stream().map(c -> new ConditionEvaluatorSupplier((EvalOperator.ExpressionEvaluator.Factory)toEvaluator.apply(c.condition), (EvalOperator.ExpressionEvaluator.Factory)toEvaluator.apply(c.value))).toList();
        EvalOperator.ExpressionEvaluator.Factory elseValueEval = toEvaluator.apply(this.elseValue);
        return dvrCtx -> new CaseEvaluator(dvrCtx, LocalExecutionPlanner.toElementType(this.dataType()), conditionsEval.stream().map(x -> x.apply(dvrCtx)).toList(), elseValueEval.get(dvrCtx));
    }

    record Condition(Expression condition, Expression value) {
    }

    private record CaseEvaluator(DriverContext driverContext, ElementType resultType, List<ConditionEvaluator> conditions, EvalOperator.ExpressionEvaluator elseVal) implements EvalOperator.ExpressionEvaluator
    {
        /*
         * Unable to fully structure code
         */
        public Block.Ref eval(Page page) {
            positionCount = page.getPositionCount();
            result = this.resultType.newBlockBuilder(positionCount, this.driverContext.blockFactory());
lbl3:
            // 3 sources

            try {
                for (p = 0; p < positionCount; ++p) {
                    positions = new int[]{p};
                    limited = new Page((Block[])IntStream.range(0, page.getBlockCount()).mapToObj((IntFunction<Block>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$eval$0(org.elasticsearch.compute.data.Page int[] int ), (I)Lorg/elasticsearch/compute/data/Block;)((Page)page, (int[])positions)).toArray((IntFunction<Block[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$eval$1(int ), (I)[Lorg/elasticsearch/compute/data/Block;)()));
                    ignored = (Releasable)LambdaMetafactory.metafactory(null, null, null, ()V, releaseBlocks(), ()V)((Page)limited);
                    for (ConditionEvaluator condition : this.conditions) {
                        conditionRef = condition.condition.eval(limited);
                        try {
                            if (conditionRef.block().areAllValuesNull() || (b = (BooleanBlock)conditionRef.block()).isNull(0) || !b.getBoolean(b.getFirstValueIndex(0))) continue;
                            valueRef = condition.value.eval(limited);
                            try {
                                result.copyFrom(valueRef.block(), 0, 1);
                                if (valueRef == null) ** GOTO lbl3
                            }
                            catch (Throwable var13_22) {
                                if (valueRef != null) {
                                    try {
                                        valueRef.close();
                                    }
                                    catch (Throwable var14_23) {
                                        var13_22.addSuppressed(var14_23);
                                    }
                                }
                                throw var13_22;
                            }
                            valueRef.close();
                            ** GOTO lbl3
                        }
                        finally {
                            if (conditionRef == null) continue;
                            conditionRef.close();
                        }
                    }
                    elseRef = this.elseVal.eval(limited);
                    try {
                        result.copyFrom(elseRef.block(), 0, 1);
                        continue;
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                var4_5 = Block.Ref.floating((Block)result.build());
                return var4_5;
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> Releasables.close(this.conditions), this.elseVal});
        }

        @Override
        public String toString() {
            return "CaseEvaluator[resultType=" + this.resultType + ", conditions=" + this.conditions + ", elseVal=" + this.elseVal + "]";
        }

        private static /* synthetic */ Block[] lambda$eval$1(int x$0) {
            return new Block[x$0];
        }

        private static /* synthetic */ Block lambda$eval$0(Page page, int[] positions, int b) {
            return page.getBlock(b).filter(positions);
        }
    }

    record ConditionEvaluatorSupplier(EvalOperator.ExpressionEvaluator.Factory condition, EvalOperator.ExpressionEvaluator.Factory value) implements Function<DriverContext, ConditionEvaluator>
    {
        @Override
        public ConditionEvaluator apply(DriverContext driverContext) {
            return new ConditionEvaluator(this.condition.get(driverContext), this.value.get(driverContext));
        }
    }

    record ConditionEvaluator(EvalOperator.ExpressionEvaluator condition, EvalOperator.ExpressionEvaluator value) implements Releasable
    {
        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.condition, this.value});
        }
    }
}

