/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.regex;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.regex.RegexMatch;

public final class RegexMatchEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator input;
    private final CharacterRunAutomaton pattern;
    private final DriverContext driverContext;

    public RegexMatchEvaluator(EvalOperator.ExpressionEvaluator input, CharacterRunAutomaton pattern, DriverContext driverContext) {
        this.input = input;
        this.pattern = pattern;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref inputRef = this.input.eval(page);){
            if (inputRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            BytesRefBlock inputBlock = (BytesRefBlock)inputRef.block();
            BytesRefVector inputVector = inputBlock.asVector();
            if (inputVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), inputBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), inputVector).asBlock());
            return ref;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock inputBlock) {
        try (BooleanBlock.Builder result = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef inputScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (inputBlock.isNull(p) || inputBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(RegexMatch.process(inputBlock.getBytesRef(inputBlock.getFirstValueIndex(p), inputScratch), this.pattern));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector inputVector) {
        try (BooleanVector.Builder result = BooleanVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef inputScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(RegexMatch.process(inputVector.getBytesRef(p, inputScratch), this.pattern));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "RegexMatchEvaluator[input=" + this.input + ", pattern=" + this.pattern + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.input);
    }
}

