/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.logical;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.logical.Not;

public final class NotEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;

    public NotEvaluator(EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.v = v;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref vRef = this.v.eval(page);){
            if (vRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            BooleanBlock vBlock = (BooleanBlock)vRef.block();
            BooleanVector vVector = vBlock.asVector();
            if (vVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), vBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), vVector).asBlock());
            return ref;
        }
    }

    public BooleanBlock eval(int positionCount, BooleanBlock vBlock) {
        try (BooleanBlock.Builder result = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p) || vBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(Not.process(vBlock.getBoolean(vBlock.getFirstValueIndex(p))));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BooleanVector vVector) {
        try (BooleanVector.Builder result = BooleanVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(Not.process(vVector.getBoolean(p)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "NotEvaluator[v=" + this.v + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }
}

